@extends('layout.layout')
@php
    $title='Avatars';
    $subTitle = 'Components / Avatars';
@endphp

@section('content')

    <div class="row gy-4">
        <div class="col-xxl-6">
            <div class="card p-0 overflow-hidden position-relative radius-12">
                <div class="card-header py-16 px-24 bg-base border border-end-0 border-start-0 border-top-0">
                    <h6 class="text-lg mb-0">Avatar Sizes</h6>
                </div>
                <div class="card-body p-24">
                    <div class="d-flex align-items-center flex-wrap gap-3">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-24-px h-24-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-32-px h-32-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-40-px h-40-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-44-px h-44-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-56-px h-56-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-64-px h-64-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-72-px h-72-px rounded-circle object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar1.png') }}" class="w-80-px h-80-px rounded-circle object-fit-cover" alt="Avatar">
                    </div>
                    <div class="d-flex align-items-center flex-wrap gap-3 mt-24">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-24-px h-24-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-32-px h-32-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-40-px h-40-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-44-px h-44-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-56-px h-56-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-64-px h-64-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-72-px h-72-px radius-8 object-fit-cover" alt="Avatar">
                        <img src="{{ asset('assets/images/avatar/avatar2.png') }}" class="w-80-px h-80-px radius-8 object-fit-cover" alt="Avatar">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-md-6">
            <div class="card p-0 overflow-hidden position-relative radius-12">
                <div class="card-header py-16 px-24 bg-base border border-end-0 border-start-0 border-top-0">
                    <h6 class="text-lg mb-0">Avatar With content</h6>
                </div>
                <div class="card-body p-24">
                    <div class="d-flex align-items-center flex-wrap gap-3">
                        <span class="w-24-px h-24-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xxs bg-primary-50 text-primary-600">24</span>
                        <span class="w-32-px h-32-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xs bg-lilac-100 text-lilac-600">32</span>
                        <span class="w-40-px h-40-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-sm bg-success-100 text-success-600">40</span>
                        <span class="w-44-px h-44-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-md bg-info-100 text-info-600">44</span>
                        <span class="w-56-px h-56-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-lg bg-warning-100 text-warning-600">56</span>
                        <span class="w-64-px h-64-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xl bg-danger-100 text-danger-600">64</span>
                    </div>
                    <div class="d-flex align-items-center flex-wrap gap-3 mt-24">
                        <span class="w-24-px h-24-px radius-4 object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xxs bg-primary-50 text-primary-600">24</span>
                        <span class="w-32-px h-32-px radius-8 object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xs bg-lilac-100 text-lilac-600">32</span>
                        <span class="w-40-px h-40-px radius-8 object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-sm bg-success-100 text-success-600">40</span>
                        <span class="w-44-px h-44-px radius-8 object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-md bg-info-100 text-info-600">44</span>
                        <span class="w-56-px h-56-px radius-8 object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-lg bg-warning-100 text-warning-600">56</span>
                        <span class="w-64-px h-64-px radius-8 object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xl bg-danger-100 text-danger-600">64</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-md-6">
            <div class="card p-0 overflow-hidden position-relative radius-12">
                <div class="card-header py-16 px-24 bg-base border border-end-0 border-start-0 border-top-0">
                    <h6 class="text-lg mb-0">Avatar Shape Style</h6>
                </div>
                <div class="card-body p-24">
                    <div class="d-flex align-items-center flex-wrap justify-content-between gap-3">
                        <img src="{{ asset('assets/images/avatar/avatar-shape1.png') }}" alt="" class="w-120-px h-120-px radius-8 object-fit-cover">
                        <img src="{{ asset('assets/images/avatar/avatar-shape2.png') }}" alt="" class="w-120-px h-120-px rounded-circle object-fit-cover">
                        <img src="{{ asset('assets/images/avatar/avatar-shape3.png') }}" alt="" class="w-auto h-120-px  object-fit-cover">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-md-6">
            <div class="card p-0 overflow-hidden position-relative radius-12 h-100">
                <div class="card-header py-16 px-24 bg-base border border-end-0 border-start-0 border-top-0">
                    <h6 class="text-lg mb-0">Status Indicator</h6>
                </div>
                <div class="card-body p-24">
                    <div class="d-flex align-items-center flex-wrap gap-3">
                        <div class="position-relative">
                            <img src="{{ asset('assets/images/avatar/status-avatar.png') }}" class="w-24-px h-24-px rounded-circle object-fit-cover" alt="Avatar">
                            <span class="w-8-px h-8-px bg-primary-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                        <div class="position-relative">
                            <img src="{{ asset('assets/images/avatar/status-avatar.png') }}" class="w-32-px h-32-px rounded-circle object-fit-cover" alt="Avatar">
                            <span class="w-8-px h-8-px bg-primary-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                        <div class="position-relative">
                            <img src="{{ asset('assets/images/avatar/status-avatar.png') }}" class="w-40-px h-40-px rounded-circle object-fit-cover" alt="Avatar">
                            <span class="w-8-px h-8-px bg-primary-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                        <div class="position-relative">
                            <img src="{{ asset('assets/images/avatar/status-avatar.png') }}" class="w-44-px h-44-px rounded-circle object-fit-cover" alt="Avatar">
                            <span class="w-8-px h-8-px bg-primary-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                    </div>
                    <div class="d-flex align-items-center flex-wrap gap-3 mt-24">
                        <div class="position-relative">
                            <span class="w-24-px h-24-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xxs bg-primary-50 text-primary-600">24</span>
                            <span class="w-8-px h-8-px bg-primary-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                        <div class="position-relative">
                            <span class="w-32-px h-32-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xxs bg-lilac-100 text-lilac-600">24</span>
                            <span class="w-8-px h-8-px bg-lilac-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                        <div class="position-relative">
                            <span class="w-40-px h-40-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xxs bg-success-100 text-success-600">24</span>
                            <span class="w-8-px h-8-px bg-success-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                        <div class="position-relative">
                            <span class="w-44-px h-44-px rounded-circle object-fit-cover d-flex justify-content-center align-items-center fw-semibold text-xxs bg-info-100 text-info-600">24</span>
                            <span class="w-8-px h-8-px bg-info-600 border br-white rounded-circle position-absolute end-0 bottom-3px"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-md-6">
            <div class="card p-0 overflow-hidden position-relative radius-12 h-100">
                <div class="card-header py-16 px-24 bg-base border border-end-0 border-start-0 border-top-0">
                    <h6 class="text-lg mb-0">Avatar Group</h6>
                </div>
                <div class="card-body p-24">
                    <div class="d-flex align-items-center flex-wrap">
                        <img src="{{ asset('assets/images/avatar/avatar-group1.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative">
                        <img src="{{ asset('assets/images/avatar/avatar-group2.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group3.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group4.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group5.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group6.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group6.png') }}" alt="" class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px">
                        <span class="w-24-px h-24-px rounded-circle object-fit-cover position-relative ms--10px border bg-neutral-100 text-secondary-light text-xs d-inline-flex align-items-center justify-content-center">
                            +5
                        </span>
                        <button type="button" class="w-24-px h-24-px rounded-circle border border-primary-600 text-primary-600 ms-8 border-dashed text-secondary-light text-xs d-inline-flex align-items-center justify-content-center">
                            <iconify-icon icon="ic:baseline-plus" class=""></iconify-icon>
                        </button>
                    </div>
                    <div class="d-flex align-items-center flex-wrap mt-24">
                        <img src="{{ asset('assets/images/avatar/avatar-group1.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative">
                        <img src="{{ asset('assets/images/avatar/avatar-group2.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group3.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group4.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group5.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group6.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px">
                        <img src="{{ asset('assets/images/avatar/avatar-group6.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px">
                        <span class="w-32-px h-32-px rounded-circle object-fit-cover position-relative ms--10px border bg-neutral-100 text-secondary-light text-xs d-inline-flex align-items-center justify-content-center">
                            +5
                        </span>
                        <button type="button" class="w-32-px h-32-px rounded-circle border border-primary-600 text-primary-600 ms-8 border-dashed text-secondary-light text-lg d-inline-flex align-items-center justify-content-center">
                            <iconify-icon icon="ic:baseline-plus" class=""></iconify-icon>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-md-6">
            <div class="card p-0 overflow-hidden position-relative radius-12 h-100">
                <div class="card-header py-16 px-24 bg-base border border-end-0 border-start-0 border-top-0">
                    <h6 class="text-lg mb-0">Images With content</h6>
                </div>
                <div class="card-body p-24">
                    <div class="row gy-3">
                        <div class="col-sm-6">
                            <div class="d-flex align-items-center gap-2">
                                <img src="{{ asset('assets/images/avatar/avatar1.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover flex-shrink-0">
                                <div class="flex-grow-1 d-inline-flex flex-column">
                                    <h6 class="text-sm mb-0">Will mart</h6>
                                    <span class="text-xs text-secondary-light">random@gmail.com</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="d-flex align-items-center gap-2">
                                <img src="{{ asset('assets/images/avatar/avatar1.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover flex-shrink-0">
                                <div class="flex-grow-1 d-inline-flex flex-column">
                                    <h6 class="text-sm mb-0">Will mart</h6>
                                    <span class="text-xs text-secondary-light">random@gmail.com</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="d-flex align-items-center gap-2">
                                <img src="{{ asset('assets/images/avatar/avatar2.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover flex-shrink-0">
                                <div class="flex-grow-1 d-inline-flex flex-column">
                                    <h6 class="text-sm mb-0">Sangeeta</h6>
                                    <span class="text-xs text-secondary-light">random@gmail.com</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="d-flex align-items-center gap-2">
                                <img src="{{ asset('assets/images/avatar/avatar2.png') }}" alt="" class="w-32-px h-32-px rounded-circle object-fit-cover flex-shrink-0">
                                <div class="flex-grow-1 d-inline-flex flex-column">
                                    <h6 class="text-sm mb-0">Sangeeta</h6>
                                    <span class="text-xs text-secondary-light">random@gmail.com</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

 @endsection