@extends('layout.layout')
@php
    $title='Card';
    $subTitle = 'Components / Card';
    $script = '<script src="' . asset('assets/js/full-calendar.js') . '"></script>
               <script src="' . asset('assets/js/flatpickr.js') . '"></script>
                 <script>
                 // Flat pickr or date picker js 
                 function getDatePicker(receiveID) {
                     flatpickr(receiveID, {
                         enableTime: true,
                         dateFormat: "d/m/Y H:i",
                     });
                 }
                 getDatePicker("#startDate");
                 getDatePicker("#endDate");
             
                 getDatePicker("#editstartDate");
                 getDatePicker("#editendDate");
                 </script>';
@endphp

@section('content')

            <div class="mb-40">
                <div class="row gy-4">
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12">
                            <img src="{{ asset('assets/images/card-component/card-img1.png') }}" class="card-img-top" alt="">
                            <div class="card-body p-16">
                                <h5 class="card-title text-lg text-primary-light
                         mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12">
                            <img src="{{ asset('assets/images/card-component/card-img2.png') }}" class="card-img-top" alt="">
                            <div class="card-body p-16 text-center">
                                <h5 class="card-title text-lg text-primary-light
                         mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <a  href="javascript:void(0)" class="btn btn-primary-600 px-12 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12">
                            <img src="{{ asset('assets/images/card-component/card-img3.png') }}" class="card-img-top" alt="">
                            <div class="card-body p-16 text-end">
                                <h5 class="card-title text-lg text-primary-light
                         mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <div class="d-flex flex-wrap align-items-center justify-content-end gap-3">
                                    <a  href="javascript:void(0)" class="btn btn-primary-100 text-white text-primary-600 px-12 py-10 d-inline-flex align-items-center gap-2">
                                        Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                    </a>
                                    <button class="btn btn-warning-100 text-white text-warning-600 px-12 py-10 d-inline-flex align-items-center gap-2">
                                        Book Mark <iconify-icon icon="bx:bookmark-minus" class="text-xl"></iconify-icon>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12">
                            <img src="{{ asset('assets/images/card-component/card-img4.png') }}" class="card-img-top" alt="">
                            <div class="card-body p-16 text-center">
                                <h5 class="card-title text-lg text-primary-light
                         mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <button class="btn btn-primary-600 px-12 py-10 d-inline-flex align-items-center gap-2">
                                    <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mb-40">
                <h6 class="mb-24">Card Text & icon </h6>
                <div class="row gy-4">
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-gradient-purple text-lilac-600 mb-16 radius-12">
                                    <iconify-icon icon="solar:medal-ribbons-star-bold" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">Brand Identity</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-lilac-600 hover-text-lilac px-0 py-0 mt-16 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 text-center">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-gradient-primary text-primary-600 mb-16 radius-12">
                                    <iconify-icon icon="ri:computer-fill" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">UI/UX Designer</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 text-end">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-gradient-success text-success-600 mb-16 radius-12">
                                    <iconify-icon icon="fluent:toolbox-20-filled" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">Business Strategy</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-success-600 hover-text-success px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 text-center">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-gradient-danger text-danger-600 mb-16 radius-12">
                                    <iconify-icon icon="ph:code-fill" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">Business Strategy</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-danger-600 hover-text-danger px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mb-40">
                <h6 class="mb-24">Card With image & Overlays </h6>
                <div class="row gy-4">
                    <div class="col-xxl-4 col-sm-6">
                        <div class="card h-100 radius-12 p-0 overflow-hidden position-relative">
                            <div class="card-body p-0 gradient-overlay bottom-0 start-0">
                                <img src="{{ asset('assets/images/card-component/card-overlay-img1.png') }}" alt="" class="w-100 h-100">
                                <div class="position-absolute start-0 bottom-0 p-24 z-1">
                                    <h5 class="card-title text-white text-primary-light
                             text-lg mb-6">This is Card title</h5>
                                    <p class="card-text text-white">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all</p>
                                    <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-10 d-inline-flex align-items-center gap-2">
                                        Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-sm-6">
                        <div class="card h-100 radius-12 p-0 overflow-hidden position-relative">
                            <div class="card-body p-0 gradient-overlay top-0 start-0">
                                <img src="{{ asset('assets/images/card-component/card-overlay-img1.png') }}" alt="" class="w-100 h-100">
                                <div class="position-absolute start-0 top-0 p-24 z-1 text-center">
                                    <h5 class="card-title text-white text-primary-light
                             text-lg mb-6">This is Card title</h5>
                                    <p class="card-text text-white">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all</p>
                                    <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-10 d-inline-flex align-items-center gap-2">
                                        Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-sm-6">
                        <div class="card h-100 radius-12 p-0 overflow-hidden position-relative">
                            <div class="card-body p-0 gradient-overlay bottom-0 start-0">
                                <img src="{{ asset('assets/images/card-component/card-overlay-img1.png') }}" alt="" class="w-100 h-100">
                                <div class="position-absolute start-0 bottom-0 p-24 z-1 text-end">
                                    <h5 class="card-title text-white text-primary-light
                             text-lg mb-6">This is Card title</h5>
                                    <p class="card-text text-white">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all</p>
                                    <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-10 d-inline-flex align-items-center gap-2">
                                        Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mb-40">
                <h6 class="mb-24">Card Header & Footer</h6>
                <div class="row gy-4">
                    <div class="col-xxl-4 col-sm-6">
                        <div class="card radius-12 h-100">
                            <div class="card-header py-16 px-24 bg-base d-flex align-items-center gap-1 justify-content-between border border-end-0 border-start-0 border-top-0">
                                <h6 class="text-lg mb-0">Hi, Will Mart</h6>
                                <button type="button" class="text-xl line-height-1">
                                    <iconify-icon icon="mdi:times" class="text-xl"></iconify-icon>
                                </button>
                            </div>
                            <div class="card-body py-16 px-24">
                                <h6 class="card-title text-primary-light mb-8 text-lg">How to learn UI /UX Design</h6>
                                <p class="card-text text-neutral-600 mb-0">Intrinsically incubate intuitive opportunities and real-time potentialities for change for interoperable meta-itself
                                    the viewer's attention from the layout</p>
                            </div>
                            <div class="card-footer text-center bg-transparent border border-end-0 border-start-0 border-bottom-0 py-16 px-24">
                                <a  href="javascript:void(0)" class="text-primary-600">View All</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-sm-6">
                        <div class="card radius-12 h-100">
                            <div class="card-body py-16 px-24">
                                <div class="d-flex align-items-center gap-2 mb-12">
                                    <iconify-icon icon="typcn:user-add" class="text-xxl"></iconify-icon>
                                    <h6 class="text-lg mb-0">How to learn UI /UX Design</h6>
                                </div>
                                <p class="card-text text-neutral-600 mb-16">Intrinsically incubate intuitive opportunities and real-time potentialities for change for interoperable meta-itself the viewer's attention from the layout</p>
                                <p class="card-text text-neutral-600 mb-0">Intrinsically incubate intuitive opportunities and real-time potentialities for change for interoperable </p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-0 d-inline-flex align-items-center gap-2 mt-16">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-sm-6">
                        <div class="card radius-12 h-100">
                            <div class="card-header py-16 px-24 bg-base d-flex align-items-center gap-1 justify-content-between border border-end-0 border-start-0 border-top-0">
                                <div>
                                    <h6 class="text-lg mb-0">How can i help your</h6>
                                    <span class="text-sm">Awesome Support</span>
                                </div>
                                <a  href="javascript:void(0)" class="text-primary-600">View All</a>
                            </div>
                            <div class="card-body py-16 px-24">
                                <p class="card-text text-neutral-600 mb-16">Intrinsically incubate intuitive opportunities and real-time potentialities for change for interoperable meta-itself the viewer's attention from the layout</p>
                                <p class="card-text text-neutral-600 mb-0">Intrinsically incubate intuitive opportunities and real-time potentialities for change for interoperable </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mb-40">
                <h6 class="mb-24">Horizontal Card</h6>
                <div class="row gy-4">
                    <div class="col-xl-6">
                        <div class="card radius-12 overflow-hidden h-100 d-flex align-items-center flex-nowrap flex-row">
                            <div class="d-flex flex-shrink-0 w-170-px h-100">
                                <img src="{{ asset('assets/images/card-component/horizontal-card-img1.png') }}" class="h-100 w-100 object-fit-cover" alt="">
                            </div>
                            <div class="card-body p-16 flex-grow-1">
                                <h5 class="card-title text-lg text-primary-light mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600 mb-16">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary p-0 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card radius-12 overflow-hidden h-100 d-flex align-items-center flex-nowrap flex-row flex-row-reverse">
                            <div class="d-flex flex-shrink-0 w-170-px h-100">
                                <img src="{{ asset('assets/images/card-component/horizontal-card-img2.png') }}" class="h-100 w-100 object-fit-cover" alt="">
                            </div>
                            <div class="card-body p-16 flex-grow-1">
                                <h5 class="card-title text-lg text-primary-light mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600 mb-16">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary p-0 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card radius-12 overflow-hidden h-100 d-flex align-items-center flex-nowrap flex-row">
                            <div class="d-flex flex-shrink-0 w-170-px h-100">
                                <img src="{{ asset('assets/images/card-component/horizontal-card-img3.png') }}" class="h-100 w-100 object-fit-cover" alt="">
                            </div>
                            <div class="card-body p-16 flex-grow-1">
                                <h5 class="card-title text-lg text-primary-light mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600 mb-16">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary p-0 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card radius-12 overflow-hidden h-100 d-flex align-items-center flex-nowrap flex-row flex-row-reverse">
                            <div class="d-flex flex-shrink-0 w-170-px h-100">
                                <img src="{{ asset('assets/images/card-component/horizontal-card-img4.png') }}" class="h-100 w-100 object-fit-cover" alt="">
                            </div>
                            <div class="card-body p-16 flex-grow-1">
                                <h5 class="card-title text-lg text-primary-light mb-6">This is Card title</h5>
                                <p class="card-text text-neutral-600 mb-16">We quickly learn to fear and thus automatically avo id potentially stressful situations of all kinds, including the most common of all .</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary p-0 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="">
                <h6 class="mb-24">Card With Background Color</h6>
                <div class="row gy-4">
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 bg-gradient-purple">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-lilac-600 text-white mb-16 radius-12">
                                    <iconify-icon icon="solar:medal-ribbons-star-bold" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">Brand Identity</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-lilac-600 hover-text-lilac px-0 py-0 mt-16 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 bg-gradient-primary text-center">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-primary-600 text-white mb-16 radius-12">
                                    <iconify-icon icon="ri:computer-fill" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">UI/UX Designer</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-primary-600 hover-text-primary px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 bg-gradient-success text-end">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-success-600 text-white mb-16 radius-12">
                                    <iconify-icon icon="fluent:toolbox-20-filled" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">Business Strategy</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-success-600 hover-text-success px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-sm-6">
                        <div class="card h-100 radius-12 bg-gradient-danger text-center">
                            <div class="card-body p-24">
                                <div class="w-64-px h-64-px d-inline-flex align-items-center justify-content-center bg-danger-600 text-white mb-16 radius-12">
                                    <iconify-icon icon="ph:code-fill" class="h5 mb-0"></iconify-icon>
                                </div>
                                <h6 class="mb-8">Business Strategy</h6>
                                <p class="card-text mb-8 text-secondary-light">Random Text gateway to the Origin al the Works Platform, & your unique block chain gateway identity.</p>
                                <a  href="javascript:void(0)" class="btn text-danger-600 hover-text-danger px-0 py-10 d-inline-flex align-items-center gap-2">
                                    Read More <iconify-icon icon="iconamoon:arrow-right-2" class="text-xl"></iconify-icon>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

@endsection