@extends('layout.layout')
@php
    $title='Dashboard';
    $subTitle = 'Investment';
    $script = ' <script src="' . asset('assets/js/homeFiveChart.js') . '"></script>';
@endphp

@section('content')

            <div class="row gy-4">

                <!-- Dashboard Widget Start -->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card px-24 py-16 shadow-none radius-8 border h-100 bg-gradient-start-3">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">
                                <div class="d-flex align-items-center">

                                    <div class="w-64-px h-64-px radius-16 bg-base-50 d-flex justify-content-center align-items-center me-20">
                                        <span class="mb-0 w-40-px h-40-px bg-primary-600 flex-shrink-0 text-white d-flex justify-content-center align-items-center radius-8 h6 mb-0">
                                            <iconify-icon icon="flowbite:users-group-solid" class="icon"></iconify-icon>
                                        </span>
                                    </div>

                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-md">New Users</span>
                                        <h6 class="fw-semibold my-1">5000</h6>
                                        <p class="text-sm mb-0">Increase by
                                            <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+200</span> this week
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Dashboard Widget End -->

                <!-- Dashboard Widget Start -->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card px-24 py-16 shadow-none radius-8 border h-100 bg-gradient-start-2">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">
                                <div class="d-flex align-items-center">

                                    <div class="w-64-px h-64-px radius-16 bg-base-50 d-flex justify-content-center align-items-center me-20">
                                        <span class="mb-0 w-40-px h-40-px bg-purple flex-shrink-0 text-white d-flex justify-content-center align-items-center radius-8 h6 mb-0">
                                            <iconify-icon icon="solar:wallet-bold" class="text-white text-2xl mb-0"></iconify-icon>
                                        </span>
                                    </div>

                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-md">Total Deposit</span>
                                        <h6 class="fw-semibold my-1">15,000</h6>
                                        <p class="text-sm mb-0">Increase by
                                            <span class="bg-danger-focus px-1 rounded-2 fw-medium text-danger-main text-sm">-200</span> this week
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Dashboard Widget End -->

                <!-- Dashboard Widget Start -->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card px-24 py-16 shadow-none radius-8 border h-100 bg-gradient-start-5">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">
                                <div class="d-flex align-items-center">

                                    <div class="w-64-px h-64-px radius-16 bg-base-50 d-flex justify-content-center align-items-center me-20">
                                        <span class="mb-0 w-40-px h-40-px bg-red flex-shrink-0 text-white d-flex justify-content-center align-items-center radius-8 h6 mb-0">
                                            <iconify-icon icon="fa6-solid:file-invoice-dollar" class="text-white text-2xl mb-0"></iconify-icon>
                                        </span>
                                    </div>

                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-md">Total Expense</span>
                                        <h6 class="fw-semibold my-1">15,000</h6>
                                        <p class="text-sm mb-0">Increase by
                                            <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+200</span> this week
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Dashboard Widget End -->

                <!-- Dashboard Widget Start -->
                <div class="col-xxl-3 col-sm-6">
                    <div class="card px-24 py-16 shadow-none radius-8 border h-100 bg-gradient-start-4">
                        <div class="card-body p-0">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-1 mb-8">
                                <div class="d-flex align-items-center">

                                    <div class="w-64-px h-64-px radius-16 bg-base-50 d-flex justify-content-center align-items-center me-20">
                                        <span class="mb-0 w-40-px h-40-px bg-success-main flex-shrink-0 text-white d-flex justify-content-center align-items-center radius-8 h6 mb-0">
                                            <iconify-icon icon="streamline:bag-dollar-solid" class="icon"></iconify-icon>
                                        </span>
                                    </div>

                                    <div>
                                        <span class="mb-2 fw-medium text-secondary-light text-md">Total Earning</span>
                                        <h6 class="fw-semibold my-1">15,000</h6>
                                        <p class="text-sm mb-0">Increase by
                                            <span class="bg-success-focus px-1 rounded-2 fw-medium text-success-main text-sm">+200</span> this week
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Dashboard Widget End -->

                <!-- Revenue Statistics Start -->
                <div class="col-xxl-8">
                    <div class="card h-100 radius-8 border-0">
                        <div class="card-body p-24">
                            <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between">
                                <div>
                                    <h6 class="mb-2 fw-bold text-lg">Revenue Statistics</h6>
                                    <span class="text-sm fw-medium text-secondary-light">Yearly earning overview</span>
                                </div>
                                <div class="">
                                    <select class="form-select form-select-sm w-auto bg-base border text-secondary-light">
                                        <option>Yearly</option>
                                        <option>Monthly</option>
                                        <option>Weekly</option>
                                        <option>Today</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mt-24 mb-24 d-flex flex-wrap">
                                <div class="me-40">
                                    <span class="text-secondary-light text-sm mb-1">Income</span>
                                    <div class="">
                                        <h6 class="fw-semibold d-inline-block mb-0">$26,201</h6>
                                        <span class="text-success-main fw-bold d-inline-flex align-items-center gap-1">10% <iconify-icon icon="iconamoon:arrow-up-2-fill" class="icon"></iconify-icon> </span>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-secondary-light text-sm mb-1">Expenses</span>
                                    <div class="">
                                        <h6 class="fw-semibold d-inline-block mb-0">$18,120</h6>
                                        <span class="text-danger-main fw-bold d-inline-flex align-items-center gap-1">10% <iconify-icon icon="iconamoon:arrow-down-2-fill" class="icon"></iconify-icon> </span>
                                    </div>
                                </div>
                            </div>

                            <div id="upDownBarchart"></div>

                        </div>
                    </div>
                </div>
                <!-- Revenue Statistics End -->

                <!-- Statistics Start -->
                <div class="col-xxl-4">
                    <div class="card h-100 radius-8 border-0">
                        <div class="card-body p-24">
                            <h6 class="mb-2 fw-bold text-lg">Statistic</h6>

                            <div class="mt-24">
                                <div class="d-flex align-items-center gap-1 justify-content-between mb-44">
                                    <div>
                                        <span class="text-secondary-light fw-normal mb-12 text-xl">Daily Conversions</span>
                                        <h5 class="fw-semibold mb-0">%60</h5>
                                    </div>
                                    <div class="position-relative">
                                        <div id="semiCircleGauge"></div>

                                        <span class="w-36-px h-36-px rounded-circle bg-neutral-100 d-flex justify-content-center align-items-center position-absolute start-50 translate-middle top-100">
                                            <iconify-icon icon="mdi:emoji" class="text-primary-600 text-md mb-0"></iconify-icon>
                                        </span>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center gap-1 justify-content-between mb-44">
                                    <div>
                                        <span class="text-secondary-light fw-normal mb-12 text-xl">Visits By Day</span>
                                        <h5 class="fw-semibold mb-0">20k</h5>
                                    </div>
                                    <div id="areaChart"></div>
                                </div>

                                <div class="d-flex align-items-center gap-1 justify-content-between">
                                    <div>
                                        <span class="text-secondary-light fw-normal mb-12 text-xl">Today Income</span>
                                        <h5 class="fw-semibold mb-0">$5.5k</h5>
                                    </div>
                                    <div id="dailyIconBarChart"></div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- Statistics End -->

                <!-- Most Location Start -->
                <div class="col-xxl-3">
                    <div class="card radius-8 border-0">

                        <div class="card-body">
                            <h6 class="mb-2 fw-bold text-lg">Most Location</h6>
                        </div>

                        <div id="world-map" class="map-sm"></div>

                        <div class="card-body p-24 max-h-266-px scroll-sm overflow-y-auto">
                            <div>

                                <div class="d-flex align-items-center justify-content-between gap-3 mb-3 pb-2">
                                    <div class="d-flex align-items-center w-100">
                                        <img src="{{ asset('assets/images/flags/flag1.png') }}" alt="" class="w-40-px h-40-px rounded-circle flex-shrink-0 me-12 overflow-hidden">
                                        <div class="flex-grow-1">
                                            <h6 class="text-sm mb-0">USA</h6>
                                            <span class="text-xs text-secondary-light fw-medium">1,240 Users</span>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 w-100">
                                        <div class="w-100 max-w-66 ms-auto">
                                            <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-primary-600 rounded-pill" style="width: 80%;"></div>
                                            </div>
                                        </div>
                                        <span class="text-secondary-light font-xs fw-semibold">80%</span>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between gap-3 mb-3 pb-2">
                                    <div class="d-flex align-items-center w-100">
                                        <img src="{{ asset('assets/images/flags/flag2.png') }}" alt="" class="w-40-px h-40-px rounded-circle flex-shrink-0 me-12 overflow-hidden">
                                        <div class="flex-grow-1">
                                            <h6 class="text-sm mb-0">Japan</h6>
                                            <span class="text-xs text-secondary-light fw-medium">1,240 Users</span>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 w-100">
                                        <div class="w-100 max-w-66 ms-auto">
                                            <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-orange rounded-pill" style="width: 60%;"></div>
                                            </div>
                                        </div>
                                        <span class="text-secondary-light font-xs fw-semibold">60%</span>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between gap-3 mb-3 pb-2">
                                    <div class="d-flex align-items-center w-100">
                                        <img src="{{ asset('assets/images/flags/flag3.png') }}" alt="" class="w-40-px h-40-px rounded-circle flex-shrink-0 me-12 overflow-hidden">
                                        <div class="flex-grow-1">
                                            <h6 class="text-sm mb-0">France</h6>
                                            <span class="text-xs text-secondary-light fw-medium">1,240 Users</span>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 w-100">
                                        <div class="w-100 max-w-66 ms-auto">
                                            <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-yellow rounded-pill" style="width: 49%;"></div>
                                            </div>
                                        </div>
                                        <span class="text-secondary-light font-xs fw-semibold">49%</span>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between gap-3">
                                    <div class="d-flex align-items-center w-100">
                                        <img src="{{ asset('assets/images/flags/flag4.png') }}" alt="" class="w-40-px h-40-px rounded-circle flex-shrink-0 me-12 overflow-hidden">
                                        <div class="flex-grow-1">
                                            <h6 class="text-sm mb-0">Germany</h6>
                                            <span class="text-xs text-secondary-light fw-medium">1,240 Users</span>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 w-100">
                                        <div class="w-100 max-w-66 ms-auto">
                                            <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-success-main rounded-pill" style="width: 100%;"></div>
                                            </div>
                                        </div>
                                        <span class="text-secondary-light font-xs fw-semibold">100%</span>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
                <!-- Most Location End -->

                <!-- My portfolio Start -->
                <div class="col-xxl-3">
                    <div class="card h-100 radius-8 border-0">
                        <div class="card-body p-24">
                            <h6 class="mb-2 fw-bold text-lg">My Portfolio</h6>

                            <div class="position-relative">
                                <span class="w-80-px h-80-px bg-base shadow text-primary-light fw-bold text-xxl d-flex justify-content-center align-items-center rounded-circle position-absolute end-0 top-0 z-1">20k</span>
                                <div id="statisticsDonutChart" class="mt-36 flex-grow-1 apexcharts-tooltip-z-none title-style circle-none"></div>
                                <span class="w-80-px h-80-px bg-base shadow text-primary-light fw-bold text-xxl d-flex justify-content-center align-items-center rounded-circle position-absolute start-0 bottom-0 z-1">50k</span>
                            </div>

                            <ul class="d-flex flex-wrap flex-column mt-64 gap-3">
                                <li class="d-flex align-items-center gap-2">
                                    <span class="w-16-px h-16-px radius-2 bg-primary-600"></span>
                                    <span class="text-secondary-light text-lg fw-normal">Total Gain:
                                        <span class="text-primary-light fw-bold text-lg">$50,000</span>
                                    </span>
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <span class="w-16-px h-16-px radius-2 bg-yellow"></span>
                                    <span class="text-secondary-light text-lg fw-normal">Total Investment:
                                        <span class="text-primary-light fw-bold text-lg">$20,000</span>
                                    </span>
                                </li>
                            </ul>

                        </div>
                    </div>
                </div>
                <!-- My portfolio End -->

                <!-- Latest Investments Start -->
                <div class="col-xxl-6">
                    <div class="card h-100">
                        <div class="card-body p-24">
                            <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between mb-20">
                                <h6 class="mb-2 fw-bold text-lg mb-0">Latest Investments</h6>
                                <a  href="javascript:void(0)" class="text-primary-600 hover-text-primary d-flex align-items-center gap-1">
                                    View All
                                    <iconify-icon icon="solar:alt-arrow-right-linear" class="icon"></iconify-icon>
                                </a>
                            </div>
                            <div class="table-responsive scroll-sm">
                                <table class="table bordered-table sm-table mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">Asset</th>
                                            <th scope="col">Quantity</th>
                                            <th scope="col">Price </th>
                                            <th scope="col">Date</th>
                                            <th scope="col" class="text-center">Total Orders</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('assets/images/asset/asset-img1.png') }}" alt="" class="flex-shrink-0 me-12 w-40-px h-40-px radius-8 me-12">
                                                    <div class="flex-grow-1">
                                                        <h6 class="text-md mb-0 fw-normal">Gold</h6>
                                                        <span class="text-sm text-secondary-light fw-normal">Main Asset</span>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="text-md mb-0 fw-normal">7500</h6>
                                                <span class="text-sm text-secondary-light fw-normal">Ounces</span>
                                            </td>
                                            <td>$7,500.00</td>
                                            <td>25 May 2024</td>
                                            <td class="text-center">
                                                <span class="bg-success-focus text-success-main px-16 py-4 radius-8 fw-medium text-sm">Completed</span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('assets/images/asset/asset-img2.png') }}" alt="" class="flex-shrink-0 me-12 w-40-px h-40-px radius-8 me-12">
                                                    <div class="flex-grow-1">
                                                        <h6 class="text-md mb-0 fw-normal">Dollars</h6>
                                                        <span class="text-sm text-secondary-light fw-normal">Currency</span>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="text-md mb-0 fw-normal">5,40,000</h6>
                                                <span class="text-sm text-secondary-light fw-normal">Dollars</span>
                                            </td>
                                            <td>$5,40,000.00</td>
                                            <td>25 May 2024</td>
                                            <td class="text-center">
                                                <span class="bg-warning-focus text-warning-main px-16 py-4 radius-8 fw-medium text-sm">In Progress</span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('assets/images/asset/asset-img3.png') }}" alt="" class="flex-shrink-0 me-12 w-40-px h-40-px radius-8 me-12">
                                                    <div class="flex-grow-1">
                                                        <h6 class="text-md mb-0 fw-normal">Stock Market</h6>
                                                        <span class="text-sm text-secondary-light fw-normal">Product</span>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="text-md mb-0 fw-normal">1500</h6>
                                                <span class="text-sm text-secondary-light fw-normal">Products</span>
                                            </td>
                                            <td>$50,000.00</td>
                                            <td>25 May 2024</td>
                                            <td class="text-center">
                                                <span class="bg-success-focus text-success-main px-16 py-4 radius-8 fw-medium text-sm">Completed</span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('assets/images/asset/asset-img4.png') }}" alt="" class="flex-shrink-0 me-12 w-40-px h-40-px radius-8 me-12">
                                                    <div class="flex-grow-1">
                                                        <h6 class="text-md mb-0 fw-normal">Dimond</h6>
                                                        <span class="text-sm text-secondary-light fw-normal">Asset</span>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="text-md mb-0 fw-normal">350</h6>
                                                <span class="text-sm text-secondary-light fw-normal">Ounces</span>
                                            </td>
                                            <td>$30,000.00</td>
                                            <td>25 May 2024</td>
                                            <td class="text-center">
                                                <span class="bg-warning-focus text-warning-main px-16 py-4 radius-8 fw-medium text-sm">In Progress</span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('assets/images/asset/asset-img5.png') }}" alt="" class="flex-shrink-0 me-12 w-40-px h-40-px radius-8 me-12">
                                                    <div class="flex-grow-1">
                                                        <h6 class="text-md mb-0 fw-normal">S&P 500</h6>
                                                        <span class="text-sm text-secondary-light fw-normal">Index</span>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="text-md mb-0 fw-normal">24,000</h6>
                                                <span class="text-sm text-secondary-light fw-normal">Shares</span>
                                            </td>
                                            <td>$63,000.00</td>
                                            <td>25 May 2024</td>
                                            <td class="text-center">
                                                <span class="bg-success-focus text-success-main px-16 py-4 radius-8 fw-medium text-sm">Completed</span>
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Latest Investments End -->

                <!-- Notice board Start -->
                <div class="col-xxl-4">
                    <div class="card h-100">
                        <div class="card-body p-24">
                            <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between mb-20">
                                <h6 class="mb-2 fw-bold text-lg mb-0">Notice board</h6>
                                <a  href="javascript:void(0)" class="text-primary-600 hover-text-primary d-flex align-items-center gap-1">
                                    View All
                                    <iconify-icon icon="solar:alt-arrow-right-linear" class="icon"></iconify-icon>
                                </a>
                            </div>

                            <div class="d-flex align-items-start gap-2 mb-20">
                                <img src="{{ asset('assets/images/notice/board-img1.png') }}" alt="" class="flex-shrink-0 w-40-px h-40-px me-12 radius-8 me-12">
                                <div class="flex-grow-1">
                                    <h6 class="text-md mb-1 fw-semibold">Admin</h6>
                                    <p class="text-sm text-secondary-light fw-medium mb-1">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy.</p>
                                    <span class="text-sm text-secondary-light fw-normal">25 Jan 2024</span>
                                </div>
                            </div>

                            <div class="d-flex align-items-start gap-2 mb-20">
                                <img src="{{ asset('assets/images/notice/board-img2.png') }}" alt="" class="flex-shrink-0 w-40-px h-40-px me-12 radius-8 me-12">
                                <div class="flex-grow-1">
                                    <h6 class="text-md mb-1 fw-semibold">Kathryn Murphy</h6>
                                    <p class="text-sm text-secondary-light fw-medium mb-1">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                                    <span class="text-sm text-secondary-light fw-normal">25 Jan 2024</span>
                                </div>
                            </div>

                            <div class="d-flex align-items-start gap-2">
                                <img src="{{ asset('assets/images/notice/board-img3.png') }}" alt="" class="flex-shrink-0 w-40-px h-40-px me-12 radius-8 me-12">
                                <div class="flex-grow-1">
                                    <h6 class="text-md mb-1 fw-semibold">Cameron Williamson</h6>
                                    <p class="text-sm text-secondary-light fw-medium mb-1">Lorem Ipsum is simply dummy text of the printing Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                                    <span class="text-sm text-secondary-light fw-normal">25 Jan 2024</span>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- Notice board End -->

                <!-- Total Transactions Start -->
                <div class="col-xxl-4">
                    <div class="card h-100">
                        <div class="card-body p-24">
                            <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between mb-20">
                                <h6 class="mb-2 fw-bold text-lg">Total Transactions </h6>
                                <div class="">
                                    <select class="form-select form-select-sm w-auto bg-base border text-secondary-light">
                                        <option>Yearly</option>
                                        <option>Monthly</option>
                                        <option>Weekly</option>
                                        <option>Today</option>
                                    </select>
                                </div>
                            </div>

                            <ul class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-28">
                                <li class="d-flex align-items-center gap-2">
                                    <span class="w-16-px h-16-px radius-2 bg-primary-600"></span>
                                    <span class="text-secondary-light text-lg fw-normal">Total Gain:
                                        <span class="text-primary-light fw-bold text-lg">$50,000</span>
                                    </span>
                                </li>
                            </ul>

                            <div id="transactionLineChart"></div>

                        </div>
                    </div>
                </div>
                <!-- Total Transactions End -->

                <!-- Project Status Start -->
                <div class="col-xxl-4">
                    <div class="card h-100">
                        <div class="card-body p-24">
                            <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between mb-20">
                                <h6 class="mb-2 fw-bold text-lg">Project Status</h6>
                                <div class="">
                                    <select class="form-select form-select-sm w-auto bg-base border text-secondary-light">
                                        <option>Yearly</option>
                                        <option>Monthly</option>
                                        <option>Weekly</option>
                                        <option>Today</option>
                                    </select>
                                </div>
                            </div>

                            <div class="table-responsive scroll-sm">
                                <table class="table sm-table bordered-table mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">Name</th>
                                            <th scope="col">Duration</th>
                                            <th scope="col">
                                                <div class="max-w-112 mx-auto">
                                                    <span>Stock</span>
                                                </div>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Gold</td>
                                            <td>2 Months</td>
                                            <td>
                                                <div class="max-w-112 mx-auto">
                                                    <div class="w-100">
                                                        <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-red rounded-pill" style="width: 30%;"></div>
                                                        </div>
                                                    </div>
                                                    <span class="mt-8 text-secondary-light text-sm fw-medium">30%</span>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Dollars</td>
                                            <td>3 Months</td>
                                            <td>
                                                <div class="max-w-112 mx-auto">
                                                    <div class="w-100">
                                                        <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-warning-main rounded-pill" style="width: 50%;"></div>
                                                        </div>
                                                    </div>
                                                    <span class="mt-8 text-secondary-light text-sm fw-medium">50%</span>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Stock Market</td>
                                            <td>1 Months</td>
                                            <td>
                                                <div class="max-w-112 mx-auto">
                                                    <div class="w-100">
                                                        <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-info-main rounded-pill" style="width: 60%;"></div>
                                                        </div>
                                                    </div>
                                                    <span class="mt-8 text-secondary-light text-sm fw-medium">60%</span>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Dimond</td>
                                            <td>5 Months</td>
                                            <td>
                                                <div class="max-w-112 mx-auto">
                                                    <div class="w-100">
                                                        <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-success-main rounded-pill" style="width: 80%;"></div>
                                                        </div>
                                                    </div>
                                                    <span class="mt-8 text-secondary-light text-sm fw-medium">80%</span>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>S&P 500</td>
                                            <td>4 Months</td>
                                            <td>
                                                <div class="max-w-112 mx-auto">
                                                    <div class="w-100">
                                                        <div class="progress progress-sm rounded-pill" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-red rounded-pill" style="width: 70%;"></div>
                                                        </div>
                                                    </div>
                                                    <span class="mt-8 text-secondary-light text-sm fw-medium">70%</span>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- Project Status End -->

            </div>

@endsection